/**
 * \file: sysmount_helper_types.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: startup
 *
 * \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
 *
 * \copyright (c) 2010, 2011 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#ifndef SYSMOUNT_HELPER_TYPES_H_
#define SYSMOUNT_HELPER_TYPES_H_

#include <sysexits.h>
#include <stdbool.h>

typedef enum error_code_t
{
	RESULT_OK					= 0,
	RESULT_HELP_PRINTED			= 1,
	RESULT_NO_MOUNT_POINT 		= 2,
	RESULT_MOUNT_ERR 			= 3,
	RESULT_INVALID_MP_PATH		= 4,
	RESULT_MP_CREATION_FAILED	= 5,
	RESULT_CANT_OPEN_CONF_FILE	= 6,
	RESULT_NO_RESOURCES			= 7,
	RESULT_INVALID_MOUNT_OPTION	= 8,
	RESULT_USAGE = EX_USAGE
} error_code_t;

/**
 * defines a data structure containing all information required for a mount point
 */
typedef struct mount_point_t
{
	char *src;
	char *mp;
	char *fs;
	unsigned long flags;
	char *data;
	bool create_mp;
} mount_point_t;

#endif /* SYSMOUNT_HELPER_TYPES_H_ */
